var Localization = 
{
    locale: "en",
    strings: {},
    mapping: { 
      "es": { 
        "regions": ["es", "ES", undefined],
        "value": ["es"],
        "alt": ["es", "419"]
      }
    },
    getString: function(token)
    {        
        if(typeof chrome != "undefined" &&
           typeof chrome.i18n != "undefined" &&
           typeof chrome.i18n.getMessage != "undefined") {
                var localizedToken = chrome.i18n.getMessage(token);
                if(localizedToken != token) {
                    Localization.locale = chrome.i18n.getUILanguage();                    
                }
                return localizedToken;
            }
        var local_locale = window.navigator.language;
        if(typeof safari != "undefined") local_locale = local_locale.toLowerCase();
        var locale_array = Localization.getRemappedLocalArray(local_locale)
        for(var i = locale_array.length - 1; i >= 0; i--)
        {
            locale = "";
            for(var j = 0; j <= i; j++)
                if(j == 0)
                    locale += locale_array[j];
                else
                    locale += "-" + locale_array[j];
            if(typeof Localization.strings[locale] != "undefined" && typeof Localization.strings[locale][token] != "undefined") {
                Localization.locale = locale;
                return Localization.strings[locale][token];
            }
        }

        if(typeof(Localization.strings["en"]) != "undefined" && typeof Localization.strings["en"][token] != "undefined") {
            return Localization.strings["en"][token];
        }
        for(var i in Localization.strings)
            if(typeof Localization.strings[i][token] != "undefined") {
                Localization.locale = i;
                return Localization.strings[i][token];
            }
        if(typeof Localization.strings[token] != "undefined") {
            Localization.locale = local_locale;
            return Localization.strings[token];
        }
        return token;
    },
    getLocalization: function() {
        var local_locale = window.navigator.language;        
        var locale_array = Localization.getRemappedLocalArray(local_locale)
        for(var i = locale_array.length - 1; i >= 0; i--)
        {
            locale = "";
            for(var j = 0; j <= i; j++)
                if(j == 0)
                    locale += locale_array[j];
                else
                    locale += "-" + locale_array[j];
            if(typeof Localization.strings[locale] != "undefined")
                return Localization.strings[locale];
        }
        return {};
    },

    getRemappedLocalArray: function(language) {
        var locale_array = language.split("-");
        if(locale_array.length == 0)
            return locale_array;
        var code = locale_array[0];
        var region = locale_array[1];
        var locale = Localization.mapping[code];
        if(typeof locale !== "undefined") {
            return  locale.regions.includes(region) ?
                    locale.value : locale.alt;
        }
        return locale_array;
    }
}

